/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.throwable;

import io.gitlab.jfronny.commons.throwable.ExceptionWrapper;
import io.gitlab.jfronny.commons.throwable.ThrowingBiConsumer;
import io.gitlab.jfronny.commons.throwable.ThrowingFunction;
import io.gitlab.jfronny.commons.throwable.ThrowingRunnable;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface ThrowingConsumer<T, TEx extends Throwable> {
    @NotNull
    public static <T> ThrowingConsumer<T, RuntimeException> of(@NotNull Consumer<T> consumer) {
        return Objects.requireNonNull(consumer)::accept;
    }

    public void accept(T var1) throws TEx;

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <V> ThrowingConsumer<V, TEx> compose(@NotNull ThrowingFunction<? super V, ? extends T, ? extends TEx> before) {
        Objects.requireNonNull(before);
        return t -> this.accept(before.apply((Object)t));
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingRunnable<TEx> compose(@NotNull ThrowingSupplier<? extends T, ? extends TEx> before) {
        Objects.requireNonNull(before);
        return () -> this.accept(before.get());
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingConsumer<T, TEx> andThen(@NotNull ThrowingConsumer<? super T, ? extends TEx> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingConsumer<T, TEx> andThen(@NotNull ThrowingRunnable<? extends TEx> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.run();
        };
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <V> ThrowingBiConsumer<T, V, TEx> compound(@NotNull ThrowingConsumer<? super V, ? extends TEx> other) {
        Objects.requireNonNull(other);
        return (l, r) -> {
            this.accept(l);
            other.accept((Object)r);
        };
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public Consumer<T> addHandler(@NotNull Consumer<Throwable> handler) {
        Objects.requireNonNull(handler);
        return t -> {
            try {
                this.accept(t);
            }
            catch (Throwable e) {
                handler.accept(e);
            }
        };
    }

    @Contract(value="_, _ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public Consumer<T> addHandler(@NotNull Class<TEx> exception, @NotNull Consumer<TEx> handler) {
        Objects.requireNonNull(exception);
        Objects.requireNonNull(handler);
        return t -> {
            try {
                this.accept(t);
            }
            catch (Throwable e) {
                if (exception.isAssignableFrom(e.getClass())) {
                    handler.accept(e);
                }
                throw ExceptionWrapper.wrap(e);
            }
        };
    }

    @Contract(value="-> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public Consumer<T> orThrow() {
        return this.orThrow(ExceptionWrapper::wrap)::accept;
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <TEx1 extends Throwable> ThrowingConsumer<T, TEx1> orThrow(@NotNull Function<Throwable, TEx1> generator) {
        Objects.requireNonNull(generator);
        return t -> {
            try {
                this.accept(t);
            }
            catch (Throwable e) {
                throw (Throwable)generator.apply(e);
            }
        };
    }

    @Contract(value="-> new", pure=true)
    @ApiStatus.NonExtendable
    default public Consumer<T> assumeSafe() {
        ThrowingConsumer consumer = this;
        return consumer::accept;
    }
}

